#include<iostream.h>
#include<fstream.h>
#include<string.h>
#include<stdlib.h>
#include<math.h>

template <class DATATYPE>

class STACK
{
	private:

		DATATYPE *data;
		int size;
		int maximum_size;

	public:

		STACK() : data(NULL) , size(0) , maximum_size(0)
		{	}

		STACK(int num)
		{
			data = new DATATYPE[num];
			size=0;
			maximum_size=num;
		}

		void size_set(int num)
		{
			data = new DATATYPE[num];
			size=0;
			maximum_size=num;
		}

		void Push(DATATYPE value)
		{
			data[++size]=value;
		}

		DATATYPE Pop()
		{
			return data[size--];
		}

		DATATYPE Peek()
		{
			return data[size];
		}

		int Get_Size()
		{
			return size;
		}

		bool isEmpty()
		{
			if (size == 0)
				return true;

			else
				return false;
		}

		bool isFull()
		{
			if (size == maximum_size)
				return true;

			else
				return false;
		}

		~STACK()
		{
			if (data!=NULL)
				delete[] data;

			size=0;
		}
};

class Polish_Notation
{
	friend istream &operator>>(istream &, Polish_Notation &);
	friend ostream &operator<< (ostream &, Polish_Notation &);

	private:
		char* infix;
		char* postfix;
		char* postfix_conversion_string;		
		char* prefix_conversion_string;		

	public:

		void infix_to_postfix();
		void infix_to_prefix();

		void display_postfix(ofstream& output);
		void display_prefix(ofstream& output);

		bool operator_precedence(char,char);
		float evaluate_postfix();		
		bool validating(char*);

		char* Get_infix();
		char* Get_Postfix();
};

char* Polish_Notation :: Get_infix()
{
	return infix;
}

char* Polish_Notation :: Get_Postfix()
{
	return postfix;
}

float Polish_Notation :: evaluate_postfix()
{
	int postfix_length=strlen(postfix);
	float value=0;
	float result=0;
	STACK<float> operand_stack(postfix_length);

	for (int i=0 ; i<postfix_length ; i++)
	{
		if (((postfix[i]>='A')&&(postfix[i]<='Z'))||((postfix[i]>='1')&&(postfix[i]<='9')))
		{
			value = postfix[i]-48;
			operand_stack.Push(value);			
		}		
		else
		{
			float second_operand=operand_stack.Pop();
			float first_operand=operand_stack.Pop();			

			if (postfix[i]=='+')
				result=first_operand+second_operand;
			
			else if (postfix[i]=='-')
				result=first_operand-second_operand;
			
			else if (postfix[i]=='*')
				result=first_operand*second_operand;
			
			else if (postfix[i]=='/')
				result=first_operand/second_operand;
			
			else if (postfix[i]=='^')
				result=pow(first_operand,second_operand);

			operand_stack.Push(result);	
		}
	}
	return operand_stack.Pop();
}

bool Polish_Notation :: validating(char* str)
{
	STACK<int> parenthesis;
	int operand, operators ;

	int string_length=strlen(str);

	for (int i=0 ; i<string_length ; i++)
	{
		if (((str[i]>='A')&&(str[i]<='Z'))||((str[i]>='1')&&(str[i]<='9')))
		{
			operand++;
		}

		else if ((str[i]=='+')||(str[i]=='-')||(str[i]=='*')||(str[i]=='/')||(str[i]=='^'))
		{
			operators++;
		}

		else if ((str[i]=='{')||(str[i]=='(')||(str[i]=='['))
		{
			parenthesis.Push(str[i]);
		}

		else if ((str[i]=='}')||(str[i]==')')||(str[i]==']'))
		{
			if ((str[i]=='}')&&(parenthesis.Peek()=='{'))
			{
				parenthesis.Pop();				
			}

			else if ((str[i]==']')&&(parenthesis.Peek()=='['))
			{
				parenthesis.Pop();				
			}

			else if ((str[i]==')')&&(parenthesis.Peek()=='('))
			{
				parenthesis.Pop();				
			}			
		}
	}

	int rank=operand-operators;

	if ((rank==1)&&(parenthesis.isEmpty()))
		return true;

	return false;
}

bool Polish_Notation :: operator_precedence(char first_operator , char second_operator)
{
	switch(first_operator)
	{
		case '+' :
			{
				if (second_operator=='*')
					return false;

				else  if (second_operator=='^')
					return false;

				else  if (second_operator=='/')
					return false;

				else
					return true;

				break;
			}


		case '-' :
			{
				if (second_operator=='*')
					return false;

				else  if (second_operator=='^')
					return false;

				else  if (second_operator=='/')
					return false;

				else
					return true;

				break;
			}

		case '*' :
			{
				if (second_operator=='^')
					return false;			
				
				else
					return true;

				break;
			}

		case '/' :
			{
				if (second_operator=='^')
					return false;
				
				else
					return true;

				break;
			}

		case '^' :
			{
				return true;

				break;
			}

		default:
			{
				cout<<"\n Invalid Number";
				break;
			}
	}
}

void Polish_Notation :: infix_to_postfix()
{
	int infix_length=strlen(infix) , conversion_counter=0;
	STACK<int> operator_stack(infix_length);

	for (int i=0 ; i<infix_length ; i++)
	{
		if (((infix[i]>='A')&&(infix[i]<='Z'))||((infix[i]>='1')&&(infix[i]<='9')))
		{
			postfix_conversion_string[conversion_counter++]=infix[i];
		}

		else
		{
			while ((!operator_stack.isEmpty())&&(operator_precedence(operator_stack.Peek(),infix[i])))
			{
				postfix_conversion_string[conversion_counter++]=operator_stack.Pop();
			}
			operator_stack.Push(infix[i]);
		}		
	}

	while(!operator_stack.isEmpty())
	{
		postfix_conversion_string[conversion_counter++]=operator_stack.Pop();
	}
}

void Polish_Notation :: display_postfix(ofstream& output)
{
	output<<"POSTFIX EXPRESSION	: "<<postfix_conversion_string<<endl;		
}

void Polish_Notation :: display_prefix(ofstream& output)
{
	output<<"PREFIX EXPRESSION	: "<<prefix_conversion_string<<endl;		
}

void Polish_Notation :: infix_to_prefix()
{
	
	int infix_length=strlen(infix) , conversion_counter=infix_length-1;
	STACK<int> operator_stack(infix_length);

	for (int i=infix_length-1 ; i>=0 ; i--)
	{
		if (((infix[i]>='A')&&(infix[i]<='Z'))||((infix[i]>='1')&&(infix[i]<='9')))
		{
			prefix_conversion_string[conversion_counter--]=infix[i];
		}

		else
		{
			while ((!operator_stack.isEmpty())&&(operator_precedence(operator_stack.Peek(),infix[i])))
			{
				prefix_conversion_string[conversion_counter--]=operator_stack.Pop();
			}
			operator_stack.Push(infix[i]);
		}		
	}

	while(!operator_stack.isEmpty())
	{
		prefix_conversion_string[conversion_counter--]=operator_stack.Pop();
	}
	
	
}

istream &operator>>(istream &input, Polish_Notation &arr)
{
	int counter=0;
	char char_counter;

	while(input>>char_counter)
	{
		++counter;
	}	

	input.clear();
	input.seekg(0);	

	arr.infix=new char[counter/2+1];
	arr.postfix_conversion_string=new char[counter/2-4];	
	arr.prefix_conversion_string=new char[counter/2-4];	

	input>>arr.infix;	

	input.clear();
	input.seekg(counter/2);	

	arr.postfix=new char[counter/2+1];	

	input>>arr.postfix;	

	return input;
}

ostream &operator<< (ostream &output, Polish_Notation &arr)
{	
	output<<arr.infix<<endl;
	output<<arr.postfix<<endl;

	return output;
}

int main(int argc , char* args[])
{
	if (argc<2)
	{
		cerr<<"INVALID NUMBER OF ARGUMENTS";
		return 1;
	}		
	
	//open file stream for the input and output
	ifstream inFile(args[1], ios::in);		

	//open file stream for the input and output	
	ofstream outFile(args[2], ios::out);

	//checks that the output file is open or not
	if (!outFile)
	{
		cerr<<"unable to open the output file"<<endl;
		return 2;
	}

	//checks that the input file is open or not
	if (!inFile)
	{
		cerr<<"unable to open the input file"<<endl;
		return 3;
	}

	Polish_Notation p;

	inFile>>p;	

	if (p.validating(p.Get_infix()))
	{
		outFile<<"INFIX EXPRESSION	: "<<"Valid"<<endl;
	}
	else
	{
		outFile<<"INFIX EXPRESSION	: "<<"Invalid"<<endl;
	}

	if (p.validating(p.Get_Postfix()))
	{
		outFile<<"POSTFIX EXPRESSION	: "<<"Valid"<<endl;
	}
	else
	{
		outFile<<"INFIX EXPRESSION	: "<<"Invalid"<<endl;
	}

	p.infix_to_postfix();
	p.display_postfix(outFile);
	outFile<<"POSTFIX EVALUATION	: "<<p.evaluate_postfix()<<endl;		

	p.infix_to_prefix();
	p.display_prefix(outFile);

	return 0;
}
